<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="disableStreamTargetModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="disableStreamTargetModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:disableStreamTargetClose()">x</button>
					<h4 id="disableStreamTargetModalLabel" class="modal-title"><wmsform:getlocalestring page="disableStreamTargetDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="disableStreamTargetDialog" obj="message"/> <b><span id="disableStreamTargetName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="disableStreamTargetDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:disableStreamTargetClose()"/>
					<wmsform:buttonok  onClick="javascript:doDisableStreamTarget()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentStreamTarget;
var currentApp;

function disableStreamTargetShow(app, streamTargetName) {
	$('#disableStreamTargetName').text(streamTargetName);
	currentApp=app;
	currentStreamTarget=streamTargetName;
	$('#disableStreamTargetModal').on("shown.bs.modal", function() {});
	$('#disableStreamTargetModal').modal('show');
}

function disableStreamTargetClose() {
	$('#disableStreamTargetModal').modal('hide');
	restartRefresh();
}

function doDisableStreamTarget() {
	$('#disableStreamTargetModal').on('hidden.bs.modal', function() {
		postAJAXForm('streamTarget/disable.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&streamTargetName='+encodeURIComponent(currentStreamTarget)+'&returnPage=${page}');
	});
	disableStreamTargetClose();
}

</script>