<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteUserModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteUserClose()">x</button>
						<h4 id="deleteUserModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteUserDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteUserDialog.message"/> <b><span id="deleteUserName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteUserDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteUserClose()"/>
						<wmsform:buttonok  onClick="javascript:doDelete()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>	
</div>

<script>

function deleteUserShow() {
	$('#deleteUserName').html(deleteUserName);
	$('#deleteUserModal').on("shown.bs.modal", function() {
	});
	$('#deleteUserModal').modal('show');	
}

function deleteUserClose() {
	$('#deleteUserModal').modal('hide');
}

function doDelete() {
	$('#deleteUserModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('server/user/delete.htm','userName='+deleteUserName);
	});
	deleteUserClose();
	return;
}

</script>