<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteTranscoderTemplateModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteTranscoderTemplateModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteTranscoderTemplateClose()">x</button>
						<h4 id="deleteTranscoderTemplateModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteTranscoderTemplateDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteTranscoderTemplateDialog.message"/> <b><span id="deleteTemplateName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteTranscoderTemplateDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteTranscoderTemplateClose()"/>
						<wmsform:buttonok  onClick="javascript:doDelete()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteTranscoderTemplateShow() {
	$("#deleteTemplateName").text(deleteTemplateDisplayName);
	$('#deleteTranscoderTemplateModal').on("shown.bs.modal", function() {
	});
	$('#deleteTranscoderTemplateModal').modal('show');	
}

function deleteTranscoderTemplateClose() {
	$('#deleteTranscoderTemplateModal').modal('hide');
}

function doDelete() {
	$('#deleteTranscoderTemplateModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent("transcoder/deletetemplate.htm", "vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&templateName="+encodeURIComponent(deleteTemplateName)); 	
	});
	deleteTranscoderTemplateClose();
	return;
}

</script>