<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<c:set var="obj">targetList</c:set>

<div id="copyStreamTargetModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="copyStreamTargetModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="copyForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:copyStreamTargetClose()">x</button>
						<h4 id="copyStreamTargetModalLabel" class="modal-title">
							<wmsform:getlocalestring page="copyStreamTargetDialog" obj="title" />
						</h4>
					</div>
					<div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="copyStreamTargetDialog" obj="message" /></p>
						<label>Source Stream Target</label>
						<div id="sourceTargetId"></div>
						<br/>
						<label><wmsform:getlocalestring page="copyStreamTargetDialog" obj="prompt" /></label>
						<input id="newStreamTargetName" path="newStreamTargetName" value="" class="form-control"/>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="newStreamTargetNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:copyStreamTargetClose()" />
								<wmsform:buttonok onClick="javascript:doCopyStreamTarget()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupStreamTargetNameError">
	<wmsform:getlocalestring page="appconfig.streamTarget.entry" obj="exists"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="common" obj="StreamTargetName.empty"/>
</c:set>
<c:set var="blankSourceError">
	<wmsform:getlocalestring page="${page}" obj="StreamTargetSourceName.empty"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="$common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#copyForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {
        	 doCopyStreamTarget();
             return false;
        }
     });
});


var sourceTarget;
function copyStreamTargetShow(srcTarget) {
	sourceTarget = srcTarget;
	$('#sourceTargetId').html(srcTarget);

	$('#newStreamTargetNameWarnings').hide();

	$('#newStreamTargetName').val("");
	$('#copyStreamTargetModal').on("shown.bs.modal", function() {
		$('#newStreamTargetName').focus();
	});
	$('#copyStreamTargetModal').modal('show');
}

function copyStreamTargetClose() {
	$('#copyStreamTargetModal').modal('hide');
	restartRefresh();
}

function doCopyStreamTarget()
{
	var ok=true;
	var tname= $("#newStreamTargetName").val().trim();
	if(tname=="")
	{
		$('#newStreamTargetNameWarnings').html("${blankNameError}");
		$('#newStreamTargetNameWarnings').show();
		ok=false;
	} else if(!isValidFileName(tname))
	{
		$('#newStreamTargetNameWarnings').html("${invalidNameError}");
		$('#newStreamTargetNameWarnings').show();
		ok=false;
	}
	if($('#copyStreamTargetName').prop("selectedIndex")==0)
	{
		$('#newStreamTargetNameWarnings').html("${blankSourceError}");
		$('#newStreamTargetNameWarnings').show();
		ok=false;
	}
	if(ok)
	{
		for (tblItem in tblDataStreamTargets) {
			if(tblDataStreamTargets[tblItem].name==tname)
			{
				$('#newStreamTargetNameWarnings').html("${dupStreamTargetNameError}");
				$('#newStreamTargetNameWarnings').show();
				ok=false;
			}
		}
	}
	if(ok)
	{
		createCopyStreamTarget(tname);
	}

}

function createCopyStreamTarget(dstTarget) {
	$('#copyStreamTargetModal').on('hidden.bs.modal', function() {
		postAJAXForm('streamTarget/copy.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&srcTarget='+ encodeURIComponent(sourceTarget) +'&dstTarget='+encodeURIComponent(dstTarget));
	});
	copyStreamTargetClose();
}

var tblDataStreamTargets = new Array();

initTableDataStreamTargets();

function initTableDataStreamTargets()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.name = "${item['streamTargetName']}";
		tblDataStreamTargets.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}



</script>
