<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<wmsform:setpagetitle page="streamFiles"/>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<c:choose>
			<c:when test="${empty appType}">
				<div class="col-md-12">
					<happ><wmsform:getlocalestring page="streamFiles" obj="pageTitle"/></happ><br>
					<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
				</div>
			</c:when>
			<c:otherwise>
				<div class="col-md-5">
					<happ>${wmsutil:escapeHtml(appName)} <wmsform:getlocalestring page="streamFiles.application" obj="head"/></happ><br>
					<small class="text-muted">${uiAppType}</small>
				</div>
				<wmsform:applicationbuttons page="${page}"/>
			</c:otherwise>
		</c:choose>
	</div>
	<div class="row col-md-12">
		<p id="pageText"></p>
	</div>
	<div class="notabs">
		<hr/>
	</div>
	<div class="row">
		<div class="col-md-8 main-content">
			<wmsform:rightrailhideshow/>
			<p><wmsform:getlocalestring page="streamFiles" obj="header"/></p>
			<h4><wmsform:getlocalestring page="streamFiles" obj="tableTitle"/></h4>
			<sec:authorize access="hasAnyRole('admin')">		
				<p>
					<c:if test="${fn:length(requestScope.formData['streamFiles'])>0}">
						<wmsform:buttonprimary page= "streamFiles" obj="copyStreamFile" onClick="javascript:copyStreamFileShow();" icon="fa fa-files-o"/>
					</c:if>
					<wmsform:button page= "streamFiles" obj="addStreamFile" onClick="javascript:addStreamFileShow()" icon="fa fa-plus" cssClass="btn btn-default"/>
				</p>
			</sec:authorize>
	
			<wmstable:viewstreamfiles page="streamFiles" readonly='false'/>

		</div>
		<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
			<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</div>
</div>

<wmsdialog:copystreamfile page="streamFiles"/>
<wmsdialog:addstreamfile page="streamFiles"/>

<script>

$(document).ready(function() {
});
</script>







