<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>
<c:set var="curUser">
	<sec:authentication property="principal" />
</c:set>

<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="action"/>
	<div id="user.warnings" class="alert alert-warning" style="display:none"><button type="button" class="close" data-dismiss="alert">&times;</button></div>
	<c:if test="${userName==curUser}">
		<div id="user.warnings" class="alert alert-warning"><wmsform:getlocalestring page="users.user" obj="formWarning"/></div>
	</c:if>
	<c:choose>
		<c:when test="${action=='new'}">
			<wmsform:editproperty page="serverUsers.user" required="yes" obj="userName" cssSize="col-md-4"/>
		</c:when>
		<c:otherwise>
			<form:hidden path="userName"/>
		</c:otherwise>
	</c:choose>
	<wmsform:editproperty page="serverUsers.user" obj="userPassword" required="yes" inputType="password"  cssSize="col-md-4"/>
	<wmsform:editproperty page="serverUsers.user" obj="userPassword2" required="yes" inputType="password"  cssSize="col-md-4"/>
	<sec:authorize access="hasAnyRole('admin')">		
		<wmsform:editpropertyradiolist page="serverUsers.user" obj="accessLevel"/>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('admin')">		
		<form:hidden path="accessLevel"/>
		<wmsform:viewproperty page="serverUsers.user" obj="accessLevel"/>
	</sec:authorize>
	<label class="control-label"><wmsform:getlocalestring page="serverUsers.user" obj="preferences"/></label>
	<wmsform:editpropertycheckbox page="serverUsers.user" obj="advUser"/>
	<p>
		<c:choose>
			<c:when test="${action=='new'}">
				<wmsform:buttonadd  onClick="javascript:saveUser()"/>
			</c:when>
			<c:otherwise>
				<wmsform:buttonsave  onClick="javascript:saveUser()"/>
			</c:otherwise>
		</c:choose>
		<c:choose>
			<c:when test="${action=='new' || action=='quickEdit'}">
				<wmsform:buttoncancel onClick="javascript:returnUsers()" />
			</c:when>
			<c:otherwise>
				<wmsform:buttoncancel onClick="javascript:showUser()" />
			</c:otherwise>
		</c:choose>
	</p>
</fieldset>



<script>
function showUser()
{
	loadAjaxMainContent("server/user/view.htm", "userName=${userName}"); 	
}

function saveUser()
{
	postAJAXForm('server/user/edit.htm','');
}
</script>
