<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<div>
   	<div id="generic.warnings" class="alert alert-warning" style="display:none"></div>
    <c:forEach var="msg" items="${formData.genericMessages}">
        <div class="row">
        	<div class="col-md-12">
      	    	<div class="alert alert-success">
            		<strong>${msg}</strong>
        		</div> 
            </div>
        </div>
    </c:forEach>

	<div class="row">
			<c:choose>
        		<c:when test="${empty appType}">
 		        	<div class="col-md-12">
						<happ>Transcoder Template &gt; ${wmsutil:escapeHtml(templateDisplayName)}</happ><br>
						<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
					</div>
        		</c:when>
        		<c:otherwise>
			        <div class="col-md-5">
			            <happ>${wmsutil:escapeHtml(appName)} > Transcoder > ${wmsutil:escapeHtml(templateDisplayName)}</happ><br>
			            <small class="text-muted">${uiAppType}</small>
			        </div>
					<wmsform:applicationbuttons page="${page}"/>
          		</c:otherwise>
        	</c:choose>
        <!--<div class="col-md-1 appbuttons" id="TranscoderButtons">
	        wmsform:buttonrestart onClick="javascript:restartServerShow()"/>
	        wmsform:buttonstop onClick="javascript:stopServerShow()" />
        </div>-->
    </div>

	<p><a href="javascript:returnTranscoderTemplates()"><i class="fa fa-arrow-left"></i> Return to Transcoder Templates</a></p>

    <div class="row">
		<div class="col-md-12">
			<ul class="nav nav-tabs" >
				<li id="Encodes" >
					<a href="javascript:showEncodesTab()">Encoding Presets</a>
				</li>
				<li id="Decode" >
					<a href="javascript:showDecodeTab()">Decoding Preset</a>
				</li>
				<li id="StreamNameGroups" >
					<a href="javascript:showStreamNameGroupsTab()">Stream Name Groups</a>
				</li>
			</ul>
		</div>
	</div>    
	<div class="row" id="tabContent">
		<div class="col-md-12">
	      	<div class="row">
				<div id="ViewMode">
					<div id="TabEncodes" style="display:none">
						<jsp:include page="ViewEncodes.jsp" flush="true" />
				 	</div>
					<div  id="TabDecode" style="display:none">
						<jsp:include page="ViewDecode.jsp" flush="true" />
					</div>
					<div id="TabStreamNameGroups" style="display:none">
						<jsp:include page="ViewStreamNameGroups.jsp" flush="true" />
				 	</div>
				 </div>
				 <div id="EditMode">
                    <div id="TabEditEncodes" style="display:none">
                       	<div class="col-md-8 main-content">
                            <form:form method="post" commandName="formData" id="defaultEncodesForm"> 
                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                <wmsform:rightrailhideshow/>
                                <jsp:include page="EditEncodes.jsp" flush="true" />
                                <form:hidden path="ignoreWarnings" />	
                            </form:form>
                         </div>
                         <div id="HelpStores" class="col-md-4 well-help pull-right right-rail">
                             <jsp:include page="HelpEncodes_${formData.currentLocale}.jsp" flush="true" />
                         </div>
                    </div>
					<div  id="TabEditDecode" style="display:none">
                       	<div class="col-md-8 main-content">
                            <form:form method="post" commandName="formData" id="defaultDecodeForm"> 
                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                <wmsform:rightrailhideshow/>
                                <jsp:include page="EditDecode.jsp" flush="true" />
                                <form:hidden path="ignoreWarnings" />	
                            </form:form>
                         </div>
                         <div id="HelpStores" class="col-md-4 right-rail well-help pull-right">
                             <jsp:include page="HelpDecode_${formData.currentLocale}.jsp" flush="true" />
                         </div>
					</div>
                    <div id="TabEditStreamNameGroups" style="display:none">
                    </div>
			 	</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>	
</div>

<script>

function returnTranscoderTemplates()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent('server/transcoder/view.htm','vhost=${wmsutil:urlEncode(vhost)}');
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/transcoder/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}"); 			
	}
}

$(document).ready(function() {
	if(typeof(lastTab) === 'undefined') {
		lastTab="Encodes";
	}
		
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#EditMode').show();
		$('#TranscoderButtons').hide();				
	}
	else 
	{
		$('#ViewMode').show();		
		$('#EditMode').hide();		
		$('#TranscoderButtons').show();				
	}
	if(lastTab=="Decode")
	{
		showDecodeTab();		
	}
	else if(lastTab=="StreamNameGroups")
	{
		showStreamNameGroupsTab();
	}
	else 
	{
		showEncodesTab();
	}
	if("${action}" == "new")
	{
	}
	else 
	{
		if("${appType}" == "")
		{
			lastTemplate="${templateName}";
			//createCookie("lastTemplate",lastTemplate);
			lastTemplateEncode="";
			//createCookie("lastTemplateEncode",lastTemplateEncode);
		}
		else 
		{
			lastTemplateApp="${templateName}";
			//createCookie("lastTemplateApp",lastTemplateApp);
			lastTemplateEncodeApp="";
			//createCookie("lastTemplateEncodeApp",lastTemplateEncodeApp);			
		}
	}
});

function showDecodeTab() {
	if("${mode}"=="edit" && lastTab!='Decode')
	{
		lastTab='Decode';
		showTemplate('${templateName}')
		return;
	}
	lastTab='Decode';
	createCookie("lastTab",lastTab);
	$('#TabDecode').show();
	$('#TabEditDecode').show();
	$('#HelpDecode').show();
	$('#TabEncodes').hide();
	$('#TabEditEncodes').hide();
	$('#TabStreamNameGroups').hide();
	$('#TabEditStreamNameGroups').hide();
	$('#Decode').addClass('active');
	$('#Encodes').removeClass();
	$('#StreamNameGroups').removeClass();
	
}

function showEncodesTab() {
	if("${mode}"=="edit" && lastTab!='Encodes')
	{
		lastTab='Encodes';
		showTemplate('${templateName}')
		return;
	}
	lastTab='Encodes';
	createCookie("lastTab",lastTab);
	$('#TabDecode').hide();
	$('#TabEditDecode').hide();
	$('#HelpDecode').hide();
	$('#TabEncodes').show();
	$('#TabEditEncodes').show();
	$('#TabStreamNameGroups').hide();
	$('#TabEditStreamNameGroups').hide();
	$('#Decode').removeClass();
	$('#Encodes').addClass('active');	
	$('#StreamNameGroups').removeClass();
}

function showStreamNameGroupsTab() {
	if("${mode}"=="edit" && lastTab!='StreamNameGroups')
	{
		lastTab='StreamNameGroups';
		showTemplate('${templateName}')
		return;
	}
	lastTab='StreamNameGroups';
	createCookie("lastTab",lastTab);
	$('#TabDecode').hide();
	$('#TabEditDecode').hide();
	$('#HelpDecode').hide();
	$('#TabEncodes').hide();
	$('#TabEditEncodes').hide();
	$('#TabStreamNameGroups').show();
	$('#TabEditStreamNameGroups').show();
	$('#Decode').removeClass();
	$('#Encodes').removeClass();
	$('#StreamNameGroups').addClass('active');
}

</script>




