<?php
require_once("inc/protecao-revenda.php");

?>
<!doctype html>
<html lang="es" dir="ltr">
  <head>
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>[<?php echo $dados_revenda["id"]; ?>] Revenda - Reseller</title>
    <link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
    <link href="/inc/css/icons.css" rel="stylesheet">
    <link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/inc/css/theme.css" rel="stylesheet">
    <link href="/inc/css/theme-dark.css" rel="stylesheet">
    <link href="/inc/css/style-transparent.css" rel="stylesheet">
    <link href="/inc/css/skin-modes.css" rel="stylesheet" />
    <link href="/inc/css/animate.css" rel="stylesheet">
    <script type="text/javascript" src="/admin/inc/ajax.js"></script>
    <script type="text/javascript" src="/admin/inc/javascript.js"></script>
  </head>
  <body class="ltr main-body app sidebar-mini <?php if($dados_revenda["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
    <!-- Loader -->
    <div id="global-loader">
      <img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
    </div>
    <!-- /Loader -->
    <!-- Page -->
    <div class="page">
      <div class="open">
        <!-- main-header -->
        <?php require_once("header-admin.php");?>       
        <!-- /main-header -->
        <!-- main-sidebar -->
        <div class="sticky">
          <aside class="app-sidebar">
            <div class="main-sidebar-header active">
              <a class="header-logo active" href="/admin/revenda">
                <?php if($dados_revenda["url_logo"]) { ?>
                <img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Revenda">
                <img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Revenda">
                <img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
                <img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
                <?php } else { ?>
                <img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
                <img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
                <img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
                <img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
                <?php } ?>
              </a>
            </div>
            <?php require_once("menu-revenda.php");?>
          </aside>
        </div>
        <!-- main-sidebar -->
      </div>

      <!-- main-content -->
      <div class="main-content app-content">

        <!-- container -->
        <div class="main-container container-fluid">

          <!-- breadcrumb -->
          <div class="breadcrumb-header justify-content-between" style="padding-top:60px">
            <div class="left-content">
              <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo lang_menu_streaming; ?></span>
            </div>
            <div class="justify-content-center mt-2">
              <ol class="breadcrumb">
                <li class="breadcrumb-item tx-15"><a href="/admin/revenda">Dashboard</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo lang_menu_streaming; ?></li>
              </ol>
            </div>
          </div>
          <!-- /breadcrumb -->

          <!-- row -->
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header d-flex custom-card-header border-bottom-0 ">
                    <header><?php echo lang_menu_streaming; ?></header>
                                        <div class="card-options">
                                            <button type="button" class="btn btn-success" onClick="ligar_streamings_revenda();" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_acao_stm_ligar_todos; ?>"><i class="fa fa-play"></i> Streamings</button>&nbsp;<button type="button" class="btn btn-info" onClick="window.location = '/admin/revenda-cadastrar-streaming';"><i class="fa fa-file-plus"></i> <?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                     <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_login; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_servidor; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_plano; ?></th>
                                                        <th class="nosort sorting_disabled" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending">FTP</th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_status; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_pagina_configurar_streaming_identificacao; ?></th>
                                                        <th class="nosort sorting_disabled" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
if(query_string('2') == "resultado") {

    if(query_string('3') == "login") {
        $query = "SELECT * FROM streamings WHERE login LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "espectadores") {
        $query = "SELECT * FROM streamings WHERE espectadores = '".query_string('4')."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "bitrate") {
        $query = "SELECT * FROM streamings WHERE bitrate = '".query_string('4')."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "identificacao") {
        $query = "SELECT * FROM streamings WHERE identificacao LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "email") {
        $query = "SELECT * FROM streamings WHERE email LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "data_cadastro") {
        $data_cadastro = query_string('6')."-".query_string('5')."-".query_string('4');
        $query = "SELECT * FROM streamings WHERE data_cadastro = '".$data_cadastro."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } else {
        $query = "SELECT * FROM streamings WHERE (login LIKE '%".query_string('4')."%' OR identificacao LIKE '%".query_string('4')."%') AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    }

} else {
$query = "SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'";
}

$sql = mysqli_query($conexao,"".$query." ORDER by login ASC");
while ($dados_stm = mysqli_fetch_array($sql)) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
$total_playlists = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."'"));

if($dados_stm["status"] > 1) {
$cor_status = "class='table-danger'";
}

$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);

if($status_streaming["status"] == "loaded") {
$status = "<i class='fa fa-check-circle text-green'>&nbsp;".lang_info_status_ligado."</i>";
} else {
$status = "<i class='fa fa-info'>&nbsp;".lang_info_status_desligado."</i>";
// Adiciona na lista para botao de ligar streaming
$array_streamings .= "".code_decode($dados_stm["login"],"E")."|";
}

if($status_streaming["status_transmissao"] == "aovivo") {
$status = "<i class='fa fa-check-circle text-red'>&nbsp;".lang_info_status_aovivo."</i>";
}

$porcentagem_uso_espaco_ftp = ($dados_stm["espaco_usado"] == 0 || $dados_stm["espaco"] == 0) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];

$servidor = ($dados_revenda["dominio_padrao"]) ? strtolower($dados_servidor["nome"]).".".$dados_revenda["dominio_padrao"] : strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

$login_code = code_decode($dados_stm["login"],"E");

echo "<tr id='".$login_code."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["login"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$servidor."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["espectadores"]." ".lang_info_subrevenda_streamings_espectadores." | ".$dados_stm["bitrate"]." Kbps | ".tamanho($dados_stm["espaco"])." FTP</td>
<td height='25' align='center' scope='col'><div class='progress progress-sm'><div class='progress-bar bg-info' role='progressbar' aria-valuenow='".$porcentagem_uso_espaco_ftp."' aria-valuemin='0' aria-valuemax='100' style='width: ".$porcentagem_uso_espaco_ftp."%;'></div></div></td>
<td height='25' align='left' scope='col'>".$status."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["identificacao"]."</td>
<td height='25' align='left' scope='col'>
<a href='/admin/revenda-configurar-streaming/".$login_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_alterar_config."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='javascript:acessar_painel_streaming_revenda(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_acessar_painel_streaming."'><i class='fa fa-home f-16 text-green'></i></a>&nbsp;
<a href='javascript:mover_streaming_revenda_subrevenda(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_mover."'><i class='fa fa-arrows f-16 text-pink'></i></a>&nbsp;
<a href='javascript:bloquear_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='javascript:remover_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_remover."'><i class='fa fa-trash-o f-16 text-red'></i></a>&nbsp;
</td>
</td>
</tr>";

unset($cor_status);
}

$array_streamings = rtrim($array_streamings, "|");
?>
                                                </tbody>
                                            </table>
                                            <input id="lista_streamings" type="hidden" value="<?php echo $array_streamings; ?>" />
                </div>
              </div>
            </div>

          <!-- cards closed -->
          </div>
          <!-- row closed -->
        </div>
        <!-- Container closed -->
      </div>
      <!-- main-content closed -->

      <!-- Country-selector modal-->
      <div class="modal fade" id="country-selector">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <div class="modal-header border-bottom">
              <h6 class="modal-title"><?php echo lang_pagina_configuracoes_idioma_painel; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
            </div>
            <div class="modal-body">
              <ul class="row p-3">
                <li class="col-lg-6 mb-2">
                  <a href="/admin/revenda-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "es") { ?>active<?php } ?>">
                    <span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
                  </a>
                </li>
                <li class="col-lg-6 mb-2 mb-2">
                  <a href="/admin/revenda-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
                    <span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
                  </a>
                </li>
                <li class="col-lg-6 mb-2">
                  <a href="/admin/revenda-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "en") { ?>active<?php } ?>">
                    <span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <!-- Modal -->
      <?php require_once("modal-revenda.php");?>
    </div>
    <!-- End Page -->
    <a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
  
    <script src="/inc/plugins/jquery/jquery.min.js"></script>
    <script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
    <script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="/inc/plugins/side-menu/sidemenu.js"></script>
    <!-- Internal Data tables -->
    <script src="/inc/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="/inc/plugins/datatable/js/dataTables.bootstrap5.js"></script>
    <script src="/inc/plugins/datatable/js/dataTables.buttons.min.js"></script>
    <script src="/inc/plugins/datatable/js/buttons.bootstrap5.min.js"></script>
    <script src="/inc/plugins/datatable/js/jszip.min.js"></script>
    <script src="/inc/plugins/datatable/pdfmake/pdfmake.min.js"></script>
    <script src="/inc/plugins/datatable/pdfmake/vfs_fonts.js"></script>
    <script src="/inc/plugins/datatable/js/buttons.html5.min.js"></script>
    <script src="/inc/plugins/datatable/js/buttons.print.min.js"></script>
    <script src="/inc/plugins/datatable/js/buttons.colVis.min.js"></script>
    <script src="/inc/plugins/datatable/dataTables.responsive.min.js"></script>
    <script src="/inc/plugins/datatable/responsive.bootstrap5.min.js"></script>
    <script src="/inc/js/table-data.js"></script>
    <!-- End Internal Data tables -->
    <script src="/inc/js/theme.js"></script>
  <script>
    
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        }); 
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/revenda-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
  </script>
</body>
</html>