#!/bin/sh
##### Instalacao do servidor de Painel Video #####
dominio_source_instalador="https://coringahost.com.br/video2025"

# Cores
EfeitoCorTitulo="\033[0;35m"
EfeitoCorOK="\033[0;32m"
EfeitoCorAlerta="\033[1;33m"
EfeitoCorErro="\033[0;31m"
EfeitoFecha="\033[0m"

# Variaveis gerais
senha_ftp=`date +%s | sha256sum | base64 | head -c 15`
senha_painel_mysql=`date +%s | sha256sum | base64 | head -c 15`
senha_root_mysql=`date +%s | sha256sum | base64 | head -c 30`
senha_admin_painel=`date +%s | sha256sum | base64 | head -c 10`

clear

if [ "$1" == "--help" ]; then

echo
echo -e "$EfeitoCorTitulo Modo de uso: sh instalador-painel-video-almalinux.sh OPCOES $EfeitoFecha"
echo
echo -e "$EfeitoCorTitulo --skip-inter          Desativa modo interativo para que não seja necessário aperta teclas para continuar $EfeitoFecha"
echo -e "$EfeitoCorTitulo --ssl                 Instala somente SSL $EfeitoFecha"
echo
exit

fi

echo
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo -e "$EfeitoCorTitulo # Script de Instalação do Painel de Streaming de Video # $EfeitoFecha"
echo -e "$EfeitoCorTitulo # Criado por Maicon - maiconbielamc@gmail.com          # $EfeitoFecha"
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo

if [ x`echo "$1" | egrep -c "\-\-app|\-\-ssl"` = x0 ]; then

echo -e "$EfeitoCorOK Instalação Painel Video Alma Linux 9 $EfeitoFecha"
echo

echo -e "$EfeitoCorAlerta Informe o domínio do painel de Video $EfeitoFecha"
read -p 'Domínio Video: ' dominio_painel_video

echo -e "$EfeitoCorAlerta Informe o domínio do player de Video $EfeitoFecha"
read -p 'Domínio Player Video: ' dominio_painel_video_player

echo -e "$EfeitoCorAlerta Informe a porta para SSH(Padrão: 6985) $EfeitoFecha"
read -p 'Porta SSH: ' porta_ssh

echo -e "$EfeitoCorAlerta Será configurado o SSL para $dominio_painel_video (painel), $dominio_painel_video_player (player) o DNS já deve estar propagado ou terá problemas na hora da instalação $EfeitoFecha"

echo
echo -e "$EfeitoCorTitulo Confirme se os dados digitados estão corretos $EfeitoFecha"
read -p 'Confirma(y/n): ' confirma

if [ "$confirma" != "${confirma#[Nn]}" ] ;then

clear

echo
echo -e "$EfeitoCorAlerta Reinicie o instalador com os dados corretos... $EfeitoFecha"
echo

exit 1

fi

if [ -z "$porta_ssh" ]; then
porta_ssh="6985"
fi

echo
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo -e "$EfeitoCorAlerta Salve estas informações abaixo para usar na instalação do ShoutCast: $EfeitoFecha"
echo
echo -e "$EfeitoCorAlerta Host MySQL: $dominio_painel_video $EfeitoFecha"
echo -e "$EfeitoCorAlerta Usuário MySQL: painel $EfeitoFecha"
echo -e "$EfeitoCorAlerta Senha MySQL: $senha_painel_mysql $EfeitoFecha"
echo -e "$EfeitoCorAlerta Banco MySQL: video $EfeitoFecha"
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo

read -n 1 -s -r -p "Pressione qualquer tecla para continuar com a instalação..."
echo
echo -e "$EfeitoCorOK Iniciando instalacao dos modulos... $EfeitoFecha"
echo

if [ "$1" == "--skip-inter" ] || [ "$2" == "--skip-inter" ]; then

echo
echo -e "$EfeitoCorAlerta Modo interativo desativado! $EfeitoFecha"
echo

silenciar="sim"

fi

echo "nameserver 8.8.8.8" > /etc/resolv.conf
echo "nameserver 8.8.4.4" >> /etc/resolv.conf

sudo dnf install epel-release -y

sudo dnf install epel-next-release -y

sudo dnf update -y

sudo dnf install iptables usermode wget nano sendmail screen nmap perl rsync gcc nano openssh-server openssh-clients kernel-devel postgresql-libs gcc glibc.i686 glibc-devel.i686 zlib-devel.i686 ncurses-devel.i686 libX11-devel.i686 libXrender.i686 libXrandr.i686 postgresql-libs openssl-devel glibc-devel unzip git net-tools sqlite-devel -y

sudo dnf install ca-certificates -y

sudo dnf install tar -y

sudo dnf remove php* -y

if ! [ -x "/usr/bin/perl" ]; then

echo
echo -e "$EfeitoCorErro Falha na instalacao de modulos essenciais, instalação cancelada, verificar logs na tela. $EfeitoFecha"
echo

exit 1
fi

cd
wget https://www.rarlab.com/rar/rarlinux-x64-5.5.0.tar.gz
tar -zxf rarlinux-x64-5.5.0.tar.gz
cd rar
cp -v rar unrar /usr/local/bin/

cd
git clone https://github.com/vergoh/vnstat
cd vnstat
./configure --prefix=/usr --sysconfdir=/etc && make && make install
vnstat --showconfig > /etc/vnstat.conf

sed -i '/DayFormat/d' /etc/vnstat.conf
sed -i '/MonthFormat/d' /etc/vnstat.conf
sed -i '/TopFormat/d' /etc/vnstat.conf

echo 'DayFormat    "%x"' >> /etc/vnstat.conf
echo "MonthFormat  \"%b '%y\"" >> /etc/vnstat.conf
echo 'TopFormat    "%x"' >> /etc/vnstat.conf

cp -v /root/vnstat/examples/systemd/vnstat.service /etc/systemd/system/

ln -s /usr/bin/nano /usr/bin/pico

iptables -F

echo 'SELINUX=disabled' > /etc/selinux/config
echo 'SELINUXTYPE=targeted' >> /etc/selinux/config

setenforce 0

systemctl disable firewalld
systemctl stop firewalld

semanage port -a -t ssh_port_t -p tcp $porta_ssh

perl -i -p -e "s/#Port 22/Port $porta_ssh/" /etc/ssh/sshd_config

update-crypto-policies --set DEFAULT:SHA1

iptables -F

service iptables save

adduser painelvideo

echo "painelvideo:$senha_ftp" | chpasswd

echo >> /etc/bashrc
echo 'ulimit -n 4096 -u 14335 -m unlimited -d unlimited -s 8192 -c 1000000 -v unlimited 2>/dev/null' >> /etc/bashrc
echo "LS_OPTIONS='--color=tty -F -a -b -T 0 -l -h';" >> /etc/bashrc
echo 'export LS_OPTIONS;' >> /etc/bashrc
echo "alias ls='/bin/ls \$LS_OPTIONS';" >> /etc/bashrc
echo 'eval `dircolors -b`' >> /etc/bashrc
echo 'PS1="\u@\h [\w]# "' >> /etc/bashrc
echo 'export VISUAL=nano' >> /etc/bashrc

source /etc/bashrc

rm -Rf /etc/localtime
ln -s /usr/share/zoneinfo/America/Sao_Paulo /etc/localtime

if [ ! "$silenciar" ]; then
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
fi

echo -e "$EfeitoCorOK Iniciando instalacao do Apache + PHP 7.2 + MariaDB $EfeitoFecha"
echo

sudo dnf update -y

sudo dnf install pure-ftpd httpd mod_ssl -y

dnf install https://rpms.remirepo.net/enterprise/remi-release-9.rpm -y 
dnf module install php:remi-7.4 -y

dnf install php php-mysqlnd php-pdo php-mbstring php-mcrypt php-xml php-gd php-curl php-bcmath php-common php-process php-tidy php-pear php-devel php-pecl-zip php-pecl-ssh2 libssh2 -y

cd /usr/share/
wget https://files.phpmyadmin.net/phpMyAdmin/5.2.1/phpMyAdmin-5.2.1-all-languages.tar.gz
tar -zxvf phpMyAdmin-5.2.1-all-languages.tar.gz
mv -f phpMyAdmin-5.2.1-all-languages phpMyAdmin

cat > /etc/httpd/conf.d/phpMyAdmin.conf << EOF

Alias /php-madm /usr/share/phpMyAdmin

<Directory /usr/share/phpMyAdmin/>
   AddDefaultCharset UTF-8
   Options Indexes FollowSymLinks MultiViews
   DirectoryIndex index.php
   AllowOverride all
   Require all granted
</Directory>

<Directory /usr/share/phpMyAdmin/setup/>
   <IfModule mod_authz_core.c>
     <RequireAny>
       Require ip 127.0.0.1
       Require ip ::1
     </RequireAny>
   </IfModule>
</Directory>

<Directory /usr/share/phpMyAdmin/libraries/>
    Order Deny,Allow
    Deny from All
    Allow from None
</Directory>

<Directory /usr/share/phpMyAdmin/setup/lib/>
    Order Deny,Allow
    Deny from All
    Allow from None
</Directory>

<Directory /usr/share/phpMyAdmin/setup/frames/>
    Order Deny,Allow
    Deny from All
    Allow from None
</Directory>

EOF

mv /etc/httpd/conf.d/userdir.conf /etc/httpd/conf.d/userdir.conf-backup

cat > /etc/httpd/conf.d/userdir.conf << EOF
<IfModule mod_userdir.c>
    UserDir disabled
</IfModule>

<Directory "/home/*/public_html">
    Options +ExecCGI +FollowSymLinks +Includes +IncludesNOEXEC +Indexes -MultiViews +SymLinksIfOwnerMatch
    AllowOverride All
    Require method GET POST OPTIONS
</Directory>

EOF

cat > /etc/httpd/conf.d/sites.conf << EOF
NameVirtualHost *:80

<VirtualHost *:80>
    DocumentRoot /home/painelvideo/public_html
    ServerName $dominio_painel_video
</VirtualHost>

NameVirtualHost *:80

<VirtualHost *:80>
    DocumentRoot /home/painelvideo/public_html/player
    ServerName $dominio_painel_video_player
    ServerAlias playerv.*
</VirtualHost>

EOF

cat > /etc/httpd/conf.d/otimizacao.conf << EOF
RLimitMEM 2865482240
RLimitCPU 640

Timeout 1000

TraceEnable Off

KeepAlive On
MaxKeepAliveRequests 5000
KeepAliveTimeout 60

<IfModule prefork.c>
    StartServers       20
    MinSpareServers    5
    MaxSpareServers   50
    ServerLimit      10000
    MaxClients       10000
    MaxRequestsPerChild  0
</IfModule>

<IfModule worker.c>
    ServerLimit              160
    StartServers             20
    MaxClients               35000
    MinSpareThreads          50
    MaxSpareThreads          300
    ThreadLimit              200
    ThreadsPerChild          200
    MaxRequestsPerChild      50000
</IfModule>

<IfModule mod_deflate.c>

   AddOutputFilterByType DEFLATE text/html
   AddOutputFilterByType DEFLATE text/plain
   AddOutputFilterByType DEFLATE text/xml
   AddOutputFilterByType DEFLATE application/xhtml+xml
   AddOutputFilterByType DEFLATE text/css
   AddOutputFilterByType DEFLATE application/xml
   AddOutputFilterByType DEFLATE image/svg+xml
   AddOutputFilterByType DEFLATE application/rss+xml
   AddOutputFilterByType DEFLATE application/atom_xml
   AddOutputFilterByType DEFLATE application/x-javascript
   AddOutputFilterByType DEFLATE application/x-httpd-php
   AddOutputFilterByType DEFLATE application/x-httpd-fastphp
   AddOutputFilterByType DEFLATE application/x-httpd-eruby

   BrowserMatch ^Mozilla/4 gzip-only-text/html
   BrowserMatch ^Mozilla/4\.0[678] no-gzip
   BrowserMatch \bMSI[E] !no-gzip !gzip-only-text/html
   Header append Vary User-Agent env=!dont-vary

   DeflateFilterNote Input instream
   DeflateFilterNote Output outstream
   DeflateFilterNote Ratio ratio
   LogFormat '"%r" %{outstream}n/%{instream}n (%{ratio}n%%) "%{User-agent}i"' DEFLATE
   CustomLog logs/deflate_log DEFLATE env=!trash

</IfModule>

EOF



sed -i '/max_execution_time/d' /etc/php.ini
sed -i '/max_input_time/d' /etc/php.ini
sed -i '/max_input_vars/d' /etc/php.ini
sed -i '/post_max_size/d' /etc/php.ini
sed -i '/upload_max_filesize/d' /etc/php.ini
sed -i '/memory_limit/d' /etc/php.ini
sed -i '/max_file_uploads/d' /etc/php.ini
sed -i '/date.timezone/d' /etc/php.ini
sed -i '/default_charset/d' /etc/php.ini

echo '' >> /etc/php.ini
echo ';Tunning Maicon - maiconbielamc@gmail.com' >> /etc/php.ini
echo 'max_execution_time = 1800' >> /etc/php.ini
echo 'max_input_time = 1800' >> /etc/php.ini
echo 'max_input_vars = 5000' >> /etc/php.ini
echo 'post_max_size = 200M' >> /etc/php.ini
echo 'upload_max_filesize = 200M' >> /etc/php.ini
echo 'memory_limit = 1024M' >> /etc/php.ini
echo 'max_file_uploads = 200' >> /etc/php.ini
echo 'date.timezone = "America/Sao_Paulo"' >> /etc/php.ini
echo 'default_charset = "ISO-8859-1"' >> /etc/php.ini

sed -i '/request_terminate_timeout/d' /etc/php-fpm.d/www.conf
echo 'request_terminate_timeout = 900' >> /etc/php-fpm.d/www.conf

cp /etc/php-fpm.d/www.conf /etc/php-fpm.d/www.conf-backup

> /etc/php-fpm.d/www.conf

cat > /etc/php-fpm.d/www.conf << EOF
[www]
user = apache
group = apache
listen = /run/php-fpm/www.sock
listen.acl_users = apache,nginx
listen.allowed_clients = 127.0.0.1
pm = dynamic
pm.max_children = 1000
pm.start_servers = 25
pm.min_spare_servers = 15
pm.max_spare_servers = 50
slowlog = /var/log/php-fpm/www-slow.log
rlimit_files = 4096
php_admin_flag[log_errors] = on
php_admin_value[memory_limit] = 2048M
php_admin_value[error_log] = /etc/httpd/logs/error_log
php_value[session.save_handler] = files
php_value[session.save_path]    = /var/lib/php/session
php_value[soap.wsdl_cache_dir]  = /var/lib/php/wsdlcache
request_terminate_timeout = 900
EOF

checar_funcao_ssh=`php -m | grep -c ssh` 

if [ "$checar_funcao_ssh" -eq 0 ]; then

echo -e "$EfeitoCorErro Erro ao instalar função SSH no PHP após concluír o instalador, instale a função no PHP. $EfeitoFecha"
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."

fi

sed -i 's/AddDefaultCharset UTF-8/AddDefaultCharset iso-8859-1/' /etc/httpd/conf/httpd.conf

echo -e "$EfeitoCorOK Iniciando instalacao dos arquivos do painel e servidor de streaming $EfeitoFecha"
echo

rm -f /etc/httpd/conf.d/welcome.conf
rm -f /etc/httpd/conf.modules.d/*mpm*.conf

echo 'LoadModule mpm_worker_module modules/mod_mpm_worker.so' > /etc/httpd/conf.modules.d/00-mpm.conf

systemctl enable httpd

dnf install mariadb-server mariadb -y

systemctl start mariadb

/usr/bin/mysqladmin -u root password "$senha_root_mysql"
/usr/bin/mysqladmin -u root -h `hostname` password "$senha_root_mysql"

touch /var/lib/mysql/servidor.err
touch /var/lib/mysql/mysql-slow.log

chmod 777 /var/lib/mysql/servidor.err /var/lib/mysql/mysql-slow.log

rm -f /etc/my.cnf.d/server.cnf /etc/my.cnf.d/mysql-clients.cnf

cat > /etc/my.cnf << EOF
[mysqld]
local-infile=0
port = 3306
datadir="/var/lib/mysql"
socket=/var/lib/mysql/mysql.sock
skip-name-resolve
skip-innodb
query_cache_limit=8M
query_cache_size=128M ## 32MB for every 1GB of RAM
query_cache_type=1
max_user_connections=25000
max_connections=10000
interactive_timeout=1800
wait_timeout=1800
connect_timeout=1800
thread_cache_size=5000
key_buffer_size=512M ## 128MB for every 1GB of RAM
join_buffer_size=16M
max_connect_errors=200
max_allowed_packet=268435456
table_cache=256
sort_buffer_size=6M ## 1MB for every 1GB of RAM
read_buffer_size=6M ## 1MB for every 1GB of RAM
read_rnd_buffer_size=6M  ## 1MB for every 1GB of RAM
thread_concurrency=10 ## Number of CPUs x 2
myisam_sort_buffer_size=24M
server-id=1
collation-server=latin1_general_ci
open_files_limit=1024000
log_error=/var/lib/mysql/servidor.err
slow-query-log = 1
slow-query-log-file = /var/lib/mysql/mysql-slow.log
long_query_time = 1 
default-storage-engine = myisam
sql-mode="NO_ENGINE_SUBSTITUTION"
EOF

systemctl restart mariadb

mysql -u root -p$senha_root_mysql -e "CREATE DATABASE IF NOT EXISTS video;GRANT ALL PRIVILEGES ON video.* TO 'painel'@'%' IDENTIFIED BY '$senha_painel_mysql'"
mysql -u root -p$senha_root_mysql -e "DELETE FROM mysql.user WHERE Password='';DELETE FROM mysql.user WHERE Host='::1';FLUSH PRIVILEGES;"

if [ ! "$silenciar" ]; then
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
fi

echo -e "$EfeitoCorOK Iniciando instalacao do Java + Android Studio $EfeitoFecha"
echo

dnf remove java* -y
dnf install java-11-openjdk java-11-openjdk-devel -y

echo "export JAVA_HOME=/usr" >> /etc/profile
echo 'export PATH=$JAVA_HOME/bin:$PATH' >> /etc/profile

cd /opt/
wget http://dl.google.com/android/android-sdk_r23.0.2-linux.tgz
tar -xzf android-sdk_r23.0.2-linux.tgz
echo "export PATH=$PATH:/opt/android-sdk-linux/platforms" >> ~/.profile
echo "export PATH=$PATH:/opt/android-sdk-linux/tools" >> ~/.profile
export PATH=$PATH:/opt/android-sdk-linux/platforms
export PATH=$PATH:/opt/android-sdk-linux/tools

(while sleep 2; do echo "y"; done) | /opt/android-sdk-linux/tools/android update sdk --no-ui

(while sleep 2; do echo "y"; done) | /opt/android-sdk-linux/tools/android update sdk --no-ui

echo y | /opt/android-sdk-linux/tools/android update sdk --no-ui --all --filter "build-tools-28.0.3"

echo y | /opt/android-sdk-linux/tools/android update sdk --no-ui --all --filter "build-tools-30.0.0-preview"

mkdir /opt/android-sdk-linux/licenses
echo 24333f8a63b6825ea9c5514f83c2829b004d1fee > /opt/android-sdk-linux/licenses/android-sdk-license

cd /opt/
wget https://dl.google.com/android/repository/android-ndk-r20-linux-x86_64.zip
unzip android-ndk-r20-linux-x86_64.zip
mv -f android-ndk-r20 android-ndk

mkdir /usr/share/httpd/.android /usr/share/httpd/.gradle
chmod 777 /usr/share/httpd/.android /usr/share/httpd/.gradle

chmod 777 /opt/android-sdk-linux -Rf

mkdir -p /home/painelvideo/public_html

cd /home/painelvideo/public_html
wget -q ${dominio_source_instalador}/painel-video-novo.zip
unzip painel-video-novo.zip
rm -f painel-video-novo.zip

cat <<EOT >> /home/painelvideo/public_html/admin/inc/conecta.php
<?php
\$host = "localhost";//nome do host
\$user = "painel";//nome de usuario do mysql
\$pass = "$senha_painel_mysql"; //senha do mysql
\$bd_streaming = "video"; //nome do banco de dados

\$conexao = mysqli_connect(\$host,\$user,\$pass);

mysqli_select_db(\$conexao,\$bd_streaming);
?>
EOT

chown painelvideo.painelvideo /home/painelvideo/public_html -Rf

chmod 0755 /home/painelvideo -Rfv

chmod 777 /home/painelvideo/public_html/app -Rf
chmod 777 /home/painelvideo/public_html/player -Rf
chmod 777 /home/painelvideo/public_html/cache -Rf
chmod 777 /home/painelvideo/public_html/temp -Rf

chmod 777 /home/painelvideo/public_html/robots/configurar-ssl-site-adm.sh

cp -Rfp /home/painelvideo/public_html/app/source-app-player /home/painelvideo/public_html/app/source_pre_compilacao
cd /home/painelvideo/public_html/app/source_pre_compilacao
replace 'codigo_versao' '1' -- app/build.gradle
replace 'numero_versao' '1.0' -- app/build.gradle
sed -i '/HASH_GRADLEW_APP/d' /home/painelvideo/public_html/app/source_pre_compilacao/gradlew
export JAVA_HOME=/usr;export PATH=$JAVA_HOME/bin:$PATH;./gradlew assembleRelease
rm -rf /home/painelvideo/public_html/app/source_pre_compilacao

clear

mysql -u root -p$senha_root_mysql video < /home/painelvideo/public_html/banco-de-dados-video.sql

mysql -u root -p$senha_root_mysql video -e "INSERT INTO administradores (codigo, nome, usuario, senha) VALUES (NULL, 'Administrador', 'admin', PASSWORD('$senha_admin_painel'))"
mysql -u root -p$senha_root_mysql video -e "INSERT INTO configuracoes (dominio_padrao, codigo_servidor_atual, manutencao) VALUES ('$dominio_painel_video', '1', 'nao')"

echo -e "$EfeitoCorOK Configurando o servidor de FTP para gerenciar arquivos do painel $EfeitoFecha"
echo

sed -i '/^$/d' /etc/pure-ftpd/pure-ftpd.conf
sed -i '/^[[:blank:]]*#/d;s/#.*//' /etc/pure-ftpd/pure-ftpd.conf
sed -i '/Authentication/d' /etc/pure-ftpd/pure-ftpd.conf
echo 'UnixAuthentication            yes' >> /etc/pure-ftpd/pure-ftpd.conf

sudo dnf install lynx -y

if [ ! "$silenciar" ]; then
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
fi
wget -O /etc/motd http://coringahost.com.br/video2025/motd.txt
echo -e "$EfeitoCorAlerta Finalizando ajustes $EfeitoFecha"
echo

cat <<EOT > /var/spool/cron/root
0 5 * * * /bin/rm -rfv /var/log/httpd/*-*
0 5 * * * /bin/rm -rfv /var/log/*-20*
0 5 * * * /bin/rm -rfv /var/spool/clientmqueue/*
0 */1 * * * /bin/echo -n > /var/spool/mail/root
0 */1 * * * /bin/echo -n > /var/log/httpd/access_log
0 */1 * * * /bin/echo -n > /var/log/httpd/deflate_log
0 */1 * * * /bin/echo -n > /var/log/httpd/error_log
0 3 * * * /bin/cp -f /dev/null /etc/httpd/logs/deflate_log
0 3 * * * /bin/cp -f /dev/null /etc/httpd/logs/access_log
0 3 * * * /bin/cp -f /dev/null /etc/httpd/logs/error_log
0 3 * * 0 /usr/bin/yum clean all
0 2 * * * /usr/bin/php /home/painelvideo/public_html/robots/limpar-logs.php
*/30 * * * * /usr/bin/php /home/painelvideo/public_html/robots/monitor-servidores.php
*/30 * * * * /usr/bin/php /home/painelvideo/public_html/robots/monitor-capacidade.php
*/10 * * * * /usr/bin/php /home/painelvideo/public_html/robots/atualizar-uso-ftp.php registros=0-20000
*/5 * * * * /usr/bin/php /home/painelvideo/public_html/robots/gerar-estatisticas-wowza.php registros=0-20000
0 3 * * 0 /usr/bin/php /home/painelvideo/public_html/robots/limpar-estatisticas.php
*/10 * * * * /usr/bin/php /home/painelvideo/public_html/robots/monitor-streamings.php registros=0-20000
* * * * * /usr/bin/php -q /home/painelvideo/public_html/robots/agendamentos.php registros=0-10000
* * * * * /usr/bin/php /home/painelvideo/public_html/robots/agendamentos-lives.php registros=0-10000
0 1 * * * /usr/bin/php /home/painelvideo/public_html/robots/backup-painel-mysql.php
0 3 * * * certbot renew --apache;systemctl reload httpd
EOT

echo -e "$EfeitoCorAlerta Será configurado o SSL para $dominio_painel_video (painel), $dominio_painel_video_player (player) o DNS já deve estar propagado ou terá problemas na hora da instalação $EfeitoFecha"
echo -e "$EfeitoCorAlerta Se DNS não foi configurado ainda OU não esta propagado(pingando) não continue, espere propagar antes de continuar apartir de aqui... $EfeitoFecha"

echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
echo

systemctl stop httpd

vversao=`wget -q -O - http://coringahost.com.br/video2025/versao.txt`

cat <<EOT > /etc/httpd/conf.d/ssl.conf
# Configurado
LoadModule ssl_module modules/mod_ssl.so

Listen 443

SSLPassPhraseDialog  builtin

SSLSessionCache         shmcb:/var/cache/mod_ssl/scache(512000)
SSLSessionCacheTimeout  300

SSLRandomSeed startup file:/dev/urandom  256
SSLRandomSeed connect builtin

SSLCryptoDevice builtin

EOT
cd

sudo dnf install lynx -y

sudo dnf -y install certbot-apache

if ! [ -x "/usr/bin/certbot" ]; then
ln -s /usr/bin/certbot-3 /usr/bin/certbot
fi

certbot -n --agree-tos --register-unsafely-without-email certonly --standalone -d $dominio_painel_video

certbot -n --agree-tos --register-unsafely-without-email certonly --standalone -d $dominio_painel_video_player



if [ -f "/etc/letsencrypt/live/$dominio_painel_video/cert.pem" ]; then

cat <<EOT >> /etc/httpd/conf.d/$dominio_painel_video.conf

NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painelvideo/public_html
    ServerName $dominio_painel_video

    ErrorLog logs/ssl_error_log
    TransferLog logs/ssl_access_log
    LogLevel warn

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_painel_video/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_painel_video/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_painel_video/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

else

echo -e "$EfeitoCorErro Erro ao instalar SSL para domínio $dominio_painel_video, verifique os logs na tela. $EfeitoFecha"
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."

fi

if [ -f "/etc/letsencrypt/live/$dominio_painel_video/cert.pem" ]; then

cat <<EOT >> /etc/httpd/conf.d/$dominio_painel_video_player.conf

NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painelvideo/public_html/player
    ServerName $dominio_painel_video_player

    ErrorLog logs/ssl_error_log
    TransferLog logs/ssl_access_log
    LogLevel warn

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_painel_video_player/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_painel_video_player/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_painel_video_player/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

else

echo -e "$EfeitoCorErro Erro ao instalar SSL para domínio $dominio_painel_video_player, verifique os logs na tela. $EfeitoFecha"
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."

fi

systemctl enable vnstat
systemctl enable pure-ftpd
systemctl enable httpd
systemctl enable crond
systemctl enable mariadb
systemctl enable php-fpm

systemctl restart sshd
systemctl restart vnstat
systemctl restart httpd
systemctl restart crond
systemctl restart pure-ftpd
systemctl restart mariadb
systemctl restart sendmail
systemctl restart php-fpm

echo
echo -e "$EfeitoCorAlerta $vversao $EfeitoFecha"
echo
echo -e "$EfeitoCorAlerta Porta SSH: $porta_ssh $EfeitoFecha"
echo
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo -e "$EfeitoCorAlerta FTP: $dominio_painel_video $EfeitoFecha"
echo -e "$EfeitoCorAlerta Usuario FTP: painelvideo $EfeitoFecha"
echo -e "$EfeitoCorAlerta Senha FTP: $senha_ftp $EfeitoFecha"
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo -e "$EfeitoCorAlerta Senha Root MySQL: $senha_root_mysql $EfeitoFecha"
echo -e "$EfeitoCorAlerta Usuário MySQL: painel $EfeitoFecha"
echo -e "$EfeitoCorAlerta Senha MySQL: $senha_painel_mysql $EfeitoFecha"
echo -e "$EfeitoCorAlerta Banco MySQL: video $EfeitoFecha"
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo -e "$EfeitoCorAlerta URL Painel: https://$dominio_painel_video/admin/login $EfeitoFecha"
echo -e "$EfeitoCorAlerta Login: admin $EfeitoFecha"
echo -e "$EfeitoCorAlerta Senha: $senha_admin_painel $EfeitoFecha"
echo
echo -e "$EfeitoCorAlerta Painel Video: /home/painelvideo/public_html $EfeitoFecha"
echo -e "$EfeitoCorAlerta Players: /home/painelvideo/public_html/player $EfeitoFecha"
echo -e "$EfeitoCorTitulo ######################################################## $EfeitoFecha"
echo
echo -e "$EfeitoCorOK Instalacao do servidor concluida. $EfeitoFecha"
echo
echo

fi

if [ x`echo "$1 $2" | grep -c "\-\-ssl"` = x1 ]; then

echo -e "$EfeitoCorAlerta Informe o domínio do painel de Video $EfeitoFecha"
read -p 'Domínio Video: ' dominio_painel_video

echo -e "$EfeitoCorAlerta Informe o domínio do player de Video $EfeitoFecha"
read -p 'Domínio Player Video: ' dominio_painel_video_player

echo -e "$EfeitoCorAlerta Será configurado o SSL para $dominio_painel_video (painel), $dominio_painel_video_player (player) o DNS já deve estar propagado ou terá problemas na hora da instalação $EfeitoFecha"

echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
echo

systemctl stop httpd

vversao=`wget -q -O - http://coringahost.com.br/video2025/versao.txt`

cat <<EOT > /etc/httpd/conf.d/ssl.conf
# Configurado
LoadModule ssl_module modules/mod_ssl.so

Listen 443

SSLPassPhraseDialog  builtin

SSLSessionCache         shmcb:/var/cache/mod_ssl/scache(512000)
SSLSessionCacheTimeout  300

SSLRandomSeed startup file:/dev/urandom  256
SSLRandomSeed connect builtin

SSLCryptoDevice builtin

EOT

sudo dnf -y install certbot-apache

if ! [ -x "/usr/bin/certbot" ]; then
ln -s /usr/bin/certbot-3 /usr/bin/certbot
fi

certbot -n --agree-tos --register-unsafely-without-email certonly --standalone -d $dominio_painel_video

certbot -n --agree-tos --register-unsafely-without-email certonly --standalone -d $dominio_painel_video_player

if [ -f "/etc/letsencrypt/live/$dominio_painel_video/cert.pem" ]; then

cat <<EOT >> /etc/httpd/conf.d/$dominio_painel_video.conf

NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painelvideo/public_html
    ServerName $dominio_painel_video

    ErrorLog logs/ssl_error_log
    TransferLog logs/ssl_access_log
    LogLevel warn

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_painel_video/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_painel_video/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_painel_video/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

else

echo -e "$EfeitoCorErro Erro ao instalar SSL para domínio $dominio_painel_video, verifique os logs na tela. $EfeitoFecha"
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."

fi

if [ -f "/etc/letsencrypt/live/$dominio_painel_video/cert.pem" ]; then

cat <<EOT >> /etc/httpd/conf.d/$dominio_painel_video_player.conf

NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painelvideo/public_html/player
    ServerName $dominio_painel_video_player

    ErrorLog logs/ssl_error_log
    TransferLog logs/ssl_access_log
    LogLevel warn

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/$dominio_painel_video_player/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/$dominio_painel_video_player/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/$dominio_painel_video_player/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

else

echo -e "$EfeitoCorErro Erro ao instalar SSL para domínio $dominio_painel_video_player, verifique os logs na tela. $EfeitoFecha"
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."

fi

systemctl restart httpd

echo
echo -e "$EfeitoCorOK Instalação concluída! $EfeitoFecha"
echo

fi